// oEndGameMenu Step event

// Ensure that pos is initialized
if (global.game_ended) {
    // Input handling for navigating the end game menu
    up_key = keyboard_check_pressed(vk_up);
    down_key = keyboard_check_pressed(vk_down);
    accept_key = keyboard_check_pressed(vk_enter);

    // Handle navigation
    pos += down_key - up_key;
    if (pos >= op_length) { pos = 0 };
    if (pos < 0) { pos = op_length - 1 };

    // Handle option selection
    if (accept_key) {
        var _sml = menu_level;  // Store current menu level

        switch(menu_level) {
            case 5:  // End Game Menu
                switch(pos) {
                    case 2:  // Try Again
                        room_restart();  // Restart the current level
                        break;
                    case 3:  // Main Menu
                        room_goto(room_main_menu);  // Go back to the main menu
                        break;
                }
                break;
        }

        // Reset position if menu level changes
        if (_sml != menu_level) { pos = 0 };

        // Update the number of options based on the current menu level
        op_length = array_length(option[menu_level]);
    }

    // Play a sound when the selection changes
    if (pos != last_selected) {
        audio_play_sound(select, 1, false);
    }
    last_selected = pos;
}
